



<html>
<head>
  <title>javabog.dk -  - Internationalisering</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel6.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel8.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_VP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">7 <a name='afsn7'></a>Internationalisering</H1>
<DIV ID="Indholdsfortegnelse18">
  <P STYLE="margin-top: 0.3cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>7.1
  Internationale programmer  122</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.1.1
  Formatering af tidspunkter  122</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.1.2
  Formatering af tal og bel&oslash;b  123</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.1.3
  Tekstindhold i resursefiler  123</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.1.4
  Avanceret: Bin&aelig;re resursefiler  124</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.1.5
  Avanceret tekstformatering  125</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>7.2
  Selv bestemme sproget  127</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.2.1
  Styre sproget fra kommandolinjen  127</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.2.2
  De mulige Locale-objekter  127</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.2.3
  Bruge Locale-objekter  128</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.2.4
  Avanceret: S&aelig;tte standardsprog  128</FONT></FONT></P>
</DIV>

<H2 CLASS="western" STYLE="">7.1 <a name='afsn7.1'></a>Internationale
programmer</SPAN></H2>
<P CLASS="western">N&aring;r et program skal anvendes af flere
kulturer og sprog, opst&aring;r behov for, at programtekster, bel&oslash;b
og dato angives i de p&aring;g&aelig;ldende landes sprog, og man m&aring;
i gang med at internationalisere og lokaliseret programmet.</P>
<P CLASS="western"><I>Internationalisering</I> (eng.:
Internationalization, ogs&aring; kaldet I18N) best&aring;r i at g&oslash;re
programmet sprogneutralt, ved at s&oslash;rge for at al formatering
og fortolkning af tal-, bel&oslash;bs-, dato- og tidsangivelser sker
afh&aelig;ngigt af sproget, og at al sproglig tekst er flyttet til
resursefiler.</P>
<P CLASS="western"><I>Lokalisering</I> best&aring;r i at overs&aelig;tte
resursefilerne til et bestemt sprog.</P>
<H3 CLASS="western">7.1.1 <a name='afsn7.1.1'></a>Formatering af tidspunkter</H3>
<P CLASS="western">DateFormat formaterer Date-objekter til strenge
(og den anden vej).</P>
<PRE CLASS="kode-western">import java.text.*;
<SPAN LANG="da-DK">import java.util.*;</SPAN>
<SPAN LANG="da-DK">public class BenytDateFormat</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String arg[])</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK">    DateFormat klformat, datoformat, dkf;</SPAN>
<SPAN LANG="da-DK"><B>    klformat   = DateFormat.getTimeInstance(DateFormat.MEDIUM);</B></SPAN>
<SPAN LANG="da-DK">    datoformat = DateFormat.getDateInstance(DateFormat.FULL);</SPAN>
<SPAN LANG="da-DK">    dkf = DateFormat.getDateTimeInstance(DateFormat.MEDIUM,DateFormat.SHORT);</SPAN>

<SPAN LANG="da-DK">    Date tid = new Date();</SPAN>
<SPAN LANG="da-DK">    System.out.println( <B>tid</B> );</SPAN>
<SPAN LANG="da-DK">    System.out.println( &quot;Kl   :&quot;+ <B>klformat.format(tid)</B> );</SPAN>
<SPAN LANG="da-DK">    System.out.println( &quot;Dato :&quot;+ datoformat.format(tid) );</SPAN>
<SPAN LANG="da-DK">    System.out.println( &quot;Tid  :&quot;+ dkf.format(tid) );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">Wed Feb 05 14:23:46 GMT+00:00 2003
<SPAN LANG="da-DK">Kl   :14:23:46</SPAN>
<SPAN LANG="da-DK">Dato :5. februar 2003</SPAN>
<SPAN LANG="da-DK">Tid  :05-02-2003 14:23</SPAN></PRE><P CLASS="western">
L&aelig;g for det f&oslash;rste m&aelig;rke til, at toString() p&aring;
Date ikke er lokaliseret. Den b&oslash;r kun bruges til
test-udskrifter og logning og ikke i tekst, som brugeren skal l&aelig;se.
</P>
<P CLASS="western">Ovenst&aring;ende program er k&oslash;rt med
danske sprogindstillinger. Med amerikanske sprogindstillinger bliver
uddata i stedet:</P>
<PRE CLASS="kode-western">Mon Dec 03 13:27:57 GMT+01:00 2001<BR>Kl:   1:27:57 PM<BR>Dato: Monday, December 3, 2001<BR>Tid:  Dec 3, 2001 1:27 PM</PRE><P CLASS="western">
Det ses, at det afh&aelig;nger en del af sproget, pr&aelig;cist
hvordan tider bliver formateret (f.eks. er ugedag med i den
amerikanske tekst, men ikke i den danske).</P>
<P CLASS="western">&Oslash;nsker man som programm&oslash;r fuld
kontrol over, hvordan teksten bliver formateret, m&aring; man selv
specificere formatet med SimpleDateFormat:</P>
<PRE CLASS="kode-western">import java.text.*;
<SPAN LANG="da-DK">import java.util.*;</SPAN>
<SPAN LANG="da-DK">public class BenytSimpleDateFormat</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String arg[])</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK">    DateFormat df = new SimpleDateFormat(&quot;EEEE 'den' d. MMMM '&aring;r' yyyy.&quot;);</SPAN>

<SPAN LANG="da-DK">    Date tid = new Date();</SPAN>
<SPAN LANG="da-DK">    System.out.println( df.format(tid) );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">mandag den 3. december &aring;r 2001.</PRE>
<P CLASS="western">Dermed bliver selve formaterings-strengen
sprogspecifik (og den b&oslash;r l&aelig;gges ud i en resursefil - se
senere). K&oslash;res den med amerikanske sprogindstillinger, bliver
uddata:</P>
<PRE CLASS="kode-western">Monday den 3. December &aring;r 2001.</PRE>
<H3 CLASS="western">7.1.2 <a name='afsn7.1.2'></a>Formatering af tal og bel&oslash;b</H3>
<P CLASS="western">P&aring; samme m&aring;de som med tidsangivelser
formateres/fortolkes tal ved at bede om et formateringsobjekt, der
klarer netop denne form for tal:</P>
<PRE CLASS="kode-western">import java.text.*;
<SPAN LANG="da-DK">public class BenytNumberFormat {</SPAN>
<SPAN LANG="da-DK">  public static void main(String arg[]) {</SPAN>
<SPAN LANG="da-DK">    NumberFormat fmt1 = <B>NumberFormat.getInstance()</B>;</SPAN>
<SPAN LANG="da-DK">    NumberFormat fmt2 = NumberFormat.getCurrencyInstance();</SPAN>
<SPAN LANG="da-DK">    NumberFormat fmt3 = NumberFormat.getPercentInstance();</SPAN>
<SPAN LANG="da-DK">    double tal = 1234.5678;</SPAN>
<SPAN LANG="da-DK">    System.out.println( <B>fmt1.format(tal)</B> );</SPAN>
<SPAN LANG="da-DK">    System.out.println( fmt2.format(tal) );</SPAN>
<SPAN LANG="da-DK">    System.out.println( fmt3.format(tal) );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">1.234,568
<SPAN LANG="da-DK">kr 1.234,57</SPAN>
<SPAN LANG="da-DK">123.457%</SPAN></PRE><P CLASS="western">
Med amerikanske sprogindstillinger bliver uddata:</P>
<PRE CLASS="kode-western">1,234.568
<SPAN LANG="da-DK">$1,234.57</SPAN>
<SPAN LANG="da-DK">123,457%</SPAN></PRE>
<H3 CLASS="western">7.1.3 <a name='afsn7.1.3'></a>Tekstindhold i resursefiler</H3>
<P CLASS="western">Programmet BenytDateFormat er halvt
internationaliseret, da tidsformateringen korrekt skifter afh&aelig;ngigt
af sproget. Der mangler kun strengene &quot;Kl:   &quot;, &quot;Dato:
&quot; og &quot;Tid:  &quot;. 
</P>
<P CLASS="western">Lad os nu fuldf&oslash;re internationaliseringen
ved at l&aelig;gge tekstindholdet (strengene) ud i et resursebundt
<SPAN STYLE="font-weight: medium">(eng.: resource bundle) </SPAN>med
navnet Tekster. Disse kan tilg&aring;s fra programmet s&aring;ledes:</P>
<PRE CLASS="kode-western">import java.text.*;
<SPAN LANG="da-DK">import java.util.*;</SPAN>
<SPAN LANG="da-DK">public class BenytDateFormatMedResurser</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String arg[])</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK">    <B>ResourceBundle res = ResourceBundle.getBundle(&quot;Tekster&quot;);</B></SPAN>
<SPAN LANG="da-DK">    DateFormat klformat, datoformat, dkf;</SPAN>
<SPAN LANG="da-DK">    klformat   = DateFormat.getTimeInstance(DateFormat.MEDIUM);</SPAN>
<SPAN LANG="da-DK">    datoformat = DateFormat.getDateInstance(DateFormat.FULL);</SPAN>
<SPAN LANG="da-DK">    dkf = DateFormat.getDateTimeInstance(DateFormat.MEDIUM,DateFormat.SHORT);</SPAN>

<SPAN LANG="da-DK">    Date tid = new Date();</SPAN>
<SPAN LANG="da-DK">    System.out.println( <B>res.getString(&quot;Kl_&quot;)</B>+ klformat.format(tid) );</SPAN>
<SPAN LANG="da-DK">    System.out.println( <B>res.getString(&quot;Dato_&quot;)</B>+ datoformat.format(tid) );</SPAN>
<SPAN LANG="da-DK">    System.out.println( <B>res.getString(&quot;Tid_&quot;)</B>+ dkf.format(tid) );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">Kl  : 14:23:50
<SPAN LANG="da-DK">Dato: 5. februar 2003</SPAN>
<SPAN LANG="da-DK">Tid : 05-02-2003 14:23</SPAN></PRE><P CLASS="western">
Resursebundtet, der skal ligge i filen Tekster.properties, indeholder
teksten i n&oslash;gle-v&aelig;rdi-par. Disse vil blive brugt, hvis
der ikke findes resursefiler for det p&aring;g&aelig;ldende sprog:</P>
<PRE CLASS="kode-western">Tid_=Tid  \:
<SPAN LANG="da-DK">Kl_=Kl   \:</SPAN>
<SPAN LANG="da-DK">Dato_=Dato \:</SPAN></PRE><P CLASS="western">
K&oslash;res programmet (p&aring; et styresystem indstillet til
dansk), f&aring;s samme udskrift som f&oslash;r.</P>
<P CLASS="western">Lad os nu lokalisere programmet til engelsk. Det
best&aring;r i, at vi opretter Tekster<B>_en</B>.properties med de
engelske tekster:</P>
<PRE CLASS="kode-western">Tid_=Time       \:
<SPAN LANG="da-DK">Kl_=Time of day\:</SPAN>
<SPAN LANG="da-DK">Dato_=Date       \:</SPAN></PRE>
<P CLASS="western">Starter vi derefter programmet med engelske
sprogindstillinger, f&aring;r vi uddata:</P>
<PRE CLASS="kode-western">Time of day : 3:07:28 PM
<SPAN LANG="da-DK">Date        : Monday, December 3, 2001</SPAN>
<SPAN LANG="da-DK">Time        : Dec 3, 2001 3:07 PM</SPAN></PRE><H4 CLASS="western">
Hvordan der s&oslash;ges efter resurser</H4>
<P CLASS="western">N&aring;r programmet skal finde en programtekst ud
fra sprogindstillingerne, sker det ved f&oslash;rst at kigge i den
mest specifikke resursefil. Hvis programteksten ikke findes der,
kigges i en mere generel resursefil og til sidst i den mest
generelle. 
</P>
<P CLASS="western">For eksempel vil resurser til sproget fr_CA
(canadisk fransk) blive s&oslash;gt</P>
<OL>
  <LI><P CLASS="western">f&oslash;rst i     Tekster_fr_CA.properties</P>
  <LI><P CLASS="western">dern&aelig;st i   Tekster_fr.properties</P>
  <LI><P CLASS="western">og sidst i   Tekster.properties</P>
</OL>
<H3 CLASS="western">7.1.4 <a name='afsn7.1.4'></a>Avanceret: Bin&aelig;re resursefiler</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel7.jsp#afsn7.1.4">
  <input type='checkbox' name='vis' value='7.1.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.1.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">7.1.5 <a name='afsn7.1.5'></a>Avanceret tekstformatering</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel7.jsp#afsn7.1.5">
  <input type='checkbox' name='vis' value='7.1.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.1.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western" STYLE="">7.2 <a name='afsn7.2'></a>Selv
bestemme sproget</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel7.jsp#afsn7.2">
  <input type='checkbox' name='vis' value='7.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<H3 CLASS="western">7.2.1 <a name='afsn7.2.1'></a>Styre sproget fra kommandolinjen</H3>
<P CLASS="western">Ved opstart af et program opretter Java et
Locale-objekt, der svarer til sprogindstillingerne p&aring; maskinen.
</P>
<P CLASS="western">P&aring; et UNIX-system g&oslash;res det ud fra
milj&oslash;variablen LC_CTYPE eller LC_ALL. Den amerikanske udskrift
til BenytDateFormat er f.eks. fundet med UNIX-kommandoen:</P>
<PRE CLASS="western">  LC_CTYPE=en java BenytDateFormat</PRE>
<H3 CLASS="western">7.2.2 <a name='afsn7.2.2'></a>De mulige Locale-objekter</H3>
<P CLASS="western">Man kan unders&oslash;ge, hvilke Locale-objekter
der er tilg&aelig;ngelige, ved at kalde klassemetoden
Locale.getAvailableLocales():</P>
<PRE CLASS="kode-western">import java.text.*;
<SPAN LANG="da-DK">import java.util.*;</SPAN>
<SPAN LANG="da-DK">public class MuligeSprog</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String arg[])</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK">    Locale[] l = Locale.getAvailableLocales();</SPAN>
<SPAN LANG="da-DK">    for (int i=0; i&lt;l.length; i++) System.out.print(l[i]+&quot; &quot;);</SPAN>
<SPAN LANG="da-DK">    System.out.println( );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">ar ar_AE ar_BH ar_DZ ar_EG ar_IQ ar_JO ar_KW ar_LB ar_LY ar_MA ar_OM ar_QA ar_SA <BR>ar_SD ar_SY ar_TN ar_YE be be_BY bg bg_BG ca ca_ES cs cs_CZ da da_DK de de_AT <BR>de_CH de_DE de_LU el el_GR en_AU en_CA en_GB en_IE en_IN en_NZ en_ZA es es_BO <BR>es_AR es_CL es_CO es_CR es_DO es_EC es_ES es_GT es_HN es_MX es_NI es_PA es_PE <BR>es_PR es_PY es_SV es_UY es_VE et et_EE fi fi_FI fr fr_BE fr_CA fr_CH fr_FR fr_LU <BR>hr hi_IN hr_HR hu hu_HU is is_IS it it_CH it_IT iw iw_IL ja ja_JP ko ko_KR lt <BR>lt_LT lv lv_LV mk mk_MK nl nl_BE nl_NL no no_NO no_NO_NY pl pl_PL pt pt_BR pt_PT <BR>ro ro_RO ru ru_RU sh sh_YU sk sk_SK sl sl_SI sq sq_AL sr sr_YU sv sv_SE th th_TH <BR>th_TH_TH tr tr_TR uk uk_UA zh zh_CN zh_HK zh_TW en en_US</PRE><P CLASS="western">
Localet best&aring;r af tre dele:</P>
<UL>
  <LI><P CLASS="western">F&oslash;rste del er sprogkoden, f.eks. da,
  sv, no, en, fr.</P>
  <LI><P CLASS="western">En valgfri anden del er landekoden, f.eks.
  DK, GB, DE, FR</P>
  <LI><P CLASS="western">En valgfri tredje del er varianten inden for
  sprogomr&aring;det (f.eks. om valutaen er i euro).</P>
</UL>
<P CLASS="western">Eksempler:</P>
<P CLASS="western">fr_BE: Fransk i Belgien</P>
<P CLASS="western">fr_BE_EURO: Fransk i Belgien med euro-valuta</P>
<P CLASS="western">fr_CA: Fransk i Canada</P>
<P CLASS="western">fr_FR: Fransk i Frankrig</P>
<P CLASS="western">fr_LU: Fransk i Luxembourg</P>

<H3 CLASS="western" STYLE="">7.2.3 <a name='afsn7.2.3'></a>Bruge
Locale-objekter</H3>
<P CLASS="western">&Oslash;nsker man finkornet kontrol over, hvilket
sprog der anvendes, kan man oprette et  Locale-objekt selv, og dette
objekt kan s&aring; bruges til at fremskaffe formateringsobjekter til
det p&aring;g&aelig;ldende sprog:</P>
<PRE CLASS="kode-western">import java.text.*;
<SPAN LANG="da-DK">import java.util.*;</SPAN>
<SPAN LANG="da-DK">public class BenytDateFormat2</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String arg[])</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK">    DateFormat klformat, datoformat;</SPAN>

<SPAN LANG="da-DK">    Locale <B>fransk = new Locale(&quot;fr&quot;,&quot;FR&quot;)</B>;</SPAN>
<SPAN LANG="da-DK">    klformat   = DateFormat.getTimeInstance(DateFormat.SHORT<B>,fransk</B>);</SPAN>
<SPAN LANG="da-DK">    datoformat = DateFormat.getDateInstance(DateFormat.LONG<B>, fransk</B>);</SPAN>

<SPAN LANG="da-DK">    Date tid = new Date();</SPAN>
<SPAN LANG="da-DK">    System.out.println( &quot;Kl:   &quot;+ klformat.format(tid) );</SPAN>
<SPAN LANG="da-DK">    System.out.println( &quot;Dato: &quot;+ datoformat.format(tid) );</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">Kl:   14:23
<SPAN LANG="da-DK">Dato: 5 f&eacute;vrier 2003</SPAN></PRE><H3 CLASS="western">
7.2.4 <a name='afsn7.2.4'></a>Avanceret: S&aelig;tte standardsprog</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel7.jsp#afsn7.2.4">
  <input type='checkbox' name='vis' value='7.2.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.2.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel6.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel8.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_VP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (71% af vrket).
</font>
<br>
nsker du at se de sidste 29% af dette vrk (362838 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
